{extends file="layouts/main.tpl"}

{block name=contents}

<div class="section-headline-wrap">
    <div class="section-headline">
        <h2>{$app.name} Forums</h2>
        <p><a href="{$url.main}" style="color:#fff;">Home</a><span class="separator">/</span><span class="current-section">{$app.name} Forums</span></p>
    </div>
</div>

<div class="section-wrap">
	<div class="section">

    <div class="content left">
        <!-- FORUM -->
        <a href="{$url.main}forum/create-topic"><button class="button secondary">Create Topic</button></a>
        {$form_alert}
        <div class="forum">
            <!-- FORUM HEADER -->
            <div class="forum-header">
                <div class="forum-title">
                    <p class="text-header small">Forum</p>
                </div>
                <div class="forum-replies">
                    <p class="text-header small">Replies</p>
                </div>
                <div class="forum-lastpost">
                    <p class="text-header small">Last Post</p>
                </div>
            </div>
            <!-- /FORUM HEADER -->

            {if $boards}
            {foreach from=$boards item=$board}
            <!-- FORUM SECTION -->
            {if $board->forums}
            <a href="{$url.main}forum/category/{$board->fcat_slug}">
            <div class="forum-subsection">
                <p class="text-header">{$board->fcat_name}</p>
                <p class="description">{$board->fcat_descrip}</p>
            </div>
            </a>
            <!-- /FORUM SECTION -->

            <!-- THREAD LIST -->
            {foreach from=$board->forums item=$fm}
            <div class="thread-list">
                <!-- THREAD LIST ITEM -->
                <div class="thread-list-item">
                    <figure class="user-avatar small">
                        <img src="{$u_photo}{$fm->user_avater}" alt="">
                    </figure>
                    <div class="forum-title">
                        <p class="text-header title">
                            <a href="{$url.main}forum/topic/{$fm->forum_slug}">{$fm->forum_title}</a>
                        </p>
                    </div>

                    <div class="forum-replies">
                        <p class="replies">{number_format($fm->total_reply)}</p>
                    </div>

                    <div class="forum-lastpost">
                    {if $fm->last_reply}
                        <p class="lastpost">{Carbon\Carbon::parse($fm->last_reply->fr_created_at)->diffForHumans(['options' => Carbon\Carbon::ONE_DAY_WORDS])} by <span>{$fm->last_reply->user_username|ucfirst}</span></p>
                        {else}
                        <p class="lastpost">{Carbon\Carbon::parse($fm->	fourm_created_at)->diffForHumans(['options' => Carbon\Carbon::ONE_DAY_WORDS])} by <span>{$fm->user_username|ucfirst}</span></p>
                    {/if}
                    </div>
                </div>
                <!-- /THREAD LIST ITEM -->

                
            </div>
            {/foreach}
            {/if}
            <!-- /THREAD LIST -->
            {/foreach}
            {/if}

        </div>
        <!-- /FORUM -->
    </div>


    {include file="inc/body/sidebar.tpl"}
    </div>
</div>
    
{/block}

{block name=custorm_css}
    {literal}
        <style>
            .button-success,
            .button-error,
            .button-warning,
            .button-secondary {
                color: white;
                border-radius: 4px;
                text-shadow: 0 1px 1px rgba(0, 0, 0, 0.2);
            }

            .button-success {
                background: rgb(28, 184, 65);
                /* this is a green */
            }

            .button-error {
                background: rgb(202, 60, 60);
                /* this is a maroon */
            }

            .button-warning {
                background: rgb(223, 117, 20);
                /* this is an orange */
            }

            .button-secondary {
                background: rgb(66, 184, 221);
                /* this is a light blue */
            }
        </style>
    {/literal}
{/block}